<?php
Redux::set_section( Minimog_Redux::OPTION_NAME, array(
	'title'  => __( 'Sidebars', 'minimog' ),
	'id'     => 'panel_sidebars',
	'icon'   => 'eicon-sidebar',
	'fields' => array(
		array(
			'id'    => 'sidebar_instruction',
			'type'  => 'info',
			'style' => 'info',
			'title' => __( 'IMPORTANT NOTE: ', 'minimog' ),
			'desc'  => sprintf( '<div class="desc">%s<br/>%s</div>',
				__( 'Sidebar 2 can only be used if sidebar 1 is selected.', 'minimog' ),
				__( 'Sidebar position option will control the position of sidebar 1. If sidebar 2 is selected, it will display on the opposite side.', 'minimog' )
			),
		),
		array(
			'id'          => 'sidebars_below_content_mobile',
			'type'        => 'button_set',
			'title'       => __( 'Sidebars Below Content', 'minimog' ),
			'description' => __( 'Move sidebars display after main content on smaller screens.', 'minimog' ),
			'options'     => array(
				'0' => __( 'No', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			),
			'default'     => Minimog_Redux::get_default_setting( 'sidebars_below_content_mobile' ),
		),
		array(
			'id'             => 'single_sidebar_width',
			'type'           => 'dimensions',
			'units'          => array( '%' ),
			'units_extended' => 'false',
			'title'          => __( 'Single Sidebar Width', 'minimog' ),
			'description'    => __( 'Controls the width of the sidebar when only one sidebar is present.', 'minimog' ),
			'height'         => false,
			'default'        => Minimog_Redux::get_default_setting( 'single_sidebar_width' ),
		),
		array(
			'id'             => 'single_sidebar_offset',
			'type'           => 'dimensions',
			'units'          => array( 'px' ),
			'units_extended' => 'false',
			'title'          => __( 'Single Sidebar Offset', 'minimog' ),
			'description'    => __( 'Controls the offset of the sidebar when only one sidebar is present.', 'minimog' ),
			'height'         => false,
			'default'        => Minimog_Redux::get_default_setting( 'single_sidebar_offset' ),
		),
		array(
			'id'             => 'dual_sidebar_width',
			'type'           => 'dimensions',
			'units'          => array( '%' ),
			'units_extended' => 'false',
			'title'          => __( 'Dual Sidebar Width', 'minimog' ),
			'description'    => __( 'Controls the width of sidebars when dual sidebars are present.', 'minimog' ),
			'height'         => false,
			'default'        => Minimog_Redux::get_default_setting( 'dual_sidebar_width' ),
		),
		array(
			'id'             => 'dual_sidebar_offset',
			'type'           => 'dimensions',
			'units'          => array( 'px' ),
			'units_extended' => 'false',
			'title'          => __( 'Dual Sidebar Offset', 'minimog' ),
			'description'    => __( 'Controls the offset of sidebars when dual sidebars are present.', 'minimog' ),
			'height'         => false,
			'default'        => Minimog_Redux::get_default_setting( 'dual_sidebar_offset' ),
		),
	),
) );
